<?php

if (! isset($_SERVER['argv'][1])) {
    die("Nie zosta przekazany aden adres URL.\n");
}

$url = $_SERVER['argv'][1];

// Pobranie strony
list($page,$pageInfo) = load_with_curl($url);

if (! strlen($page)) {
    die("Nie mona pobra strony spod adresu $url");
}

// Przeksztacenie do kodu XML  ze wzgldu na atwo analizowania
$opts = array('output-xhtml' => true,
              'numeric-entities' => true);
$xml = tidy_repair_string($page, $opts);
$doc = new DOMDocument();
$doc->loadXML($xml);
$xpath = new DOMXPath($doc);
$xpath->registerNamespace('xhtml','http://www.w3.org/1999/xhtml');

// Wyznaczenie bazowego adresu URL dla odsyaczy wzgldnych
$baseURL = '';
// Sprawdzenie, czy w kodzie strony zosta zamieszczony element <base href=""/>
$nodeList = $xpath->query('//xhtml:base/@href');
if ($nodeList->length == 1) {
    $baseURL = $nodeList->item(0)->nodeValue;
}
// Brak elementu <base href=""/> - bazowy adres URL zostanie wyznaczony na podstwie $url
else {
    $URLParts = parse_url($pageInfo['url']);
    if (! (isset($URLParts['path']) && strlen($URLParts['path']))) {
        $basePath = '';
    } else {
        $basePath = preg_replace('#/[^/]*$#','',$URLParts['path']);
    }
    if (isset($URLParts['username']) || isset($URLParts['password'])) {
        $auth = isset($URLParts['username']) ? $URLParts['username'] : '';
        $auth .= ':';
        $auth .= isset($URLParts['password']) ? $URLParts['password'] : '';
        $auth .= '@';
    } else {
        $auth = '';
    }
    $baseURL = $URLParts['scheme'] . '://' . 
               $auth . $URLParts['host'] .
               $basePath;
}

// Przechowanie informacji o sprawdzonych odsyaczach, aby nie wystpi przypadek
// powtrnego odwoania do tego samego adresu
$seenLinks = array();

// Wyodrbnienie wszystkich odsyaczy
$links = $xpath->query('//xhtml:a/@href');

foreach ($links as $node) {
    $link = $node->nodeValue;
    // Zamiana adresw wzgldnych na bezwgldne
    if (! preg_match('#^(http|https|mailto):#', $link)) {
        if (((strlen($link) == 0)) || ($link[0] != '/')) {
            $link = '/' . $link;
        }
        $link = $baseURL . $link;
    }
    // Pominicie odsyacza, ktry by wczeniej analizowany
    if (isset($seenLinks[$link])) {
        continue;
    }
    // Oznaczenie odsyacza jako sprawdzonego
    $seenLinks[$link] = true;
    // Wywietlenie informacji o sprawdzanym odsyaczu
    print $link.': ';
    flush();
    
    list($linkHeaders, $linkInfo) = load_with_curl($link, 'HEAD');
    // Okrelenie dalszego sposobu dziaania na podstawie kodu odpowiedzi
    // Odpowied o kodzie 2xx oznacza, e odsyacz jest poprawny
    if (($linkInfo['http_code'] >= 200) && ($linkInfo['http_code'] < 300)) {
        $status = 'OK';
    }
    // Odpowied o kodzie 3xx oznacza przeniesienie strony w inne miejsce
    else if (($linkInfo['http_code'] >= 300) && ($linkInfo['http_code'] < 400)) {
        $status = 'Przeniesiono';
        if (preg_match('/^Location: (.*)$/m',$linkHeaders,$match)) {
                $status .= ': ' . trim($match[1]);
        }
    }
    // Inne kody odpowiedzi oznaczaj bd odsyacza
    else {
        $status = "Bd: {$linkInfo['http_code']}";
    }
    // Wywietlenie informacji na temat odsyacza
    print "$status\n";
}

function load_with_curl($url, $method = 'GET') {
    $c = curl_init($url);
    curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
    if ($method == 'GET') {
        curl_setopt($c,CURLOPT_FOLLOWLOCATION, true);
    } 
    else if ($method == 'HEAD') {
        curl_setopt($c, CURLOPT_NOBODY, true);
        curl_setopt($c, CURLOPT_HEADER, true);
    }
    $response = curl_exec($c);
    return array($response, curl_getinfo($c));
}
?>
